#include <stdio.h>
#include <string.h>
#include "cpuid.h"


CpuInfo::CpuInfo(void)
{
	int CPUfeatures=0, CPUfamily=0, CPUmodel=0, CPUstepping=0;
	char CPUvendor[13];

	__asm
	{
		pushad					// save registers

// Intel386 processor check
// The AC bit, bit #18, is a new bit introduced in the EFLAGS
// register on the Intel486 processor to generate alignment
// faults.
// This bit cannot be set on the Intel386 processor.

		mov		byte ptr [CPUvendor] , 0
		mov		byte ptr [CPUvendor][12] , 0
		pushfd					// push original EFLAGS
		pop		eax				// get original EFLAGS
		mov		ecx , eax		// save original EFLAGS
		xor		eax , 40000h	// flip AC bit in EFLAGS
		push	eax				// save new EFLAGS value on stack
		popfd					// replace current EFLAGS value
		pushfd					// get new EFLAGS
		pop		eax				// store new EFLAGS in EAX
		xor		eax , ecx		// cant toggle AC bit, processor=80386
		mov		[CPUfamily] , 3	// turn on 80386 processor flag
		jz		__end_cpu_type	// jump if 80386 processor

// Intel486 processor check
// Checking for ability to set/clear ID flag (Bit 21) in EFLAGS
// which indicates the presence of a processor with the CPUID
// instruction.

		push	ecx
		popfd					// restore AC bit in EFLAGS first
		mov		[CPUfamily] , 4	// turn on 80486 processor flag
		mov		eax , 200000h	// get original EFLAGS
		or		ecx , eax		// flip ID bit in EFLAGS
		push	ecx				// save new EFLAGS value on stack
		popfd					// replace current EFLAGS value
		pushfd					// get new EFLAGS
		pop		ecx				// store new EFLAGS in EAX
		and		ecx , eax		// can't set ID bit,
		jz		__end_cpu_type	// processor=80486

// Execute CPUID instruction to not determine vendor, family,
// model, stepping and features. For the purpose of this
// code, only the initial set of CPUID information is saved.

		mov		eax , 0			// set up for CPUID instruction
		_emit 0x0f				// CPUID
		_emit 0xa2				// get and save vendor ID
		mov		dword ptr [CPUvendor][0] , ebx
		mov		dword ptr [CPUvendor][4] , edx
		mov		dword ptr [CPUvendor][8] , ecx
		cmp		eax , 1
		jl		__end_cpu_type
		mov		eax , 1			// set up for CPUID instruction
		_emit 0x0f				// CPUID
		_emit 0xa2				// get and save vendor ID
		mov		[CPUfeatures] , edx
		mov		ecx , eax
		shr		ecx , 8
		and		ecx , 0fH
		mov		[CPUfamily] , ecx
		mov		ecx , eax
		shr		ecx , 4
		and		ecx , 0fH
		mov		[CPUmodel] , eax
		mov		ecx , eax
		shr		ecx , 4
		and		ecx , 0fH
		mov		[CPUstepping] , eax

__end_cpu_type:
		popad
	}

	_family = CPUfamily;
	_model = CPUmodel;
	_stepping = CPUstepping;
	strcpy(_vendorID, CPUvendor);
	*((int *)&_features) = CPUfeatures;
}


const char* CpuInfo::getInfo(void)
{
	static char buf[400];

	sprintf(buf, 
		"CPU familia: %d\n"
		"CPU vendedor: %s\n"
		"MMX disponible: %s\n",
		getCPUfamily(),
		getCPUvendorID(),
		hasMMX() ? "Si" : "No");

	return(buf);
}
